<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CText extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);

		$this->name = "text";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"landing"				=> "landing.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		
		$text = $this->pageTitleBlock();
		$this->module->plugins["seo"]->PageMeta($text);

		$text["title"] = $text["text_block_1_title"] ? $this->_t("landing")->blockReplace("Title" , $text) : "";
				
		if ($text["text_image"] && $this->private->templates["landing"]->BlockExists("Image")) {
			$text["image"] = $this->private->templates["landing"]->BlockReplace(
				"Image",
				$text
			);
		} else {
			$text["image"] = "";
		}


		$this->SetComments($this->tpl_module["settings"]["set_comments"], array("link" => $this->tpl_module["link"]));
		

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$this->private->templates["landing"]->blockREplacE(
				"Main" , 
				$text,
				$this->tpl_module
			)
		);

	}

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}

}
